// PCMag_ODBC_OLTP_Write.cpp

#include "stdafx.h"
#include "PCMAG_ODBC_MSSQL.h"
#include "PCMag_ODBC_MSSQL_OLTP_Write.h"

// IMPLEMENT_SERIAL macro calls
IMPLEMENT_SERIAL(CXact_OLTP_Write_01,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Write_02,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Write_03,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Write_04,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Write_05,CXact,1)

// ================================================================================

// CXact_OLTP_Write_01

CXact_OLTP_Write_01::CXact_OLTP_Write_01 (void)
{
	m_szName		= "OLTP Write 01";
	m_szDescription = "oltp_write_01 (randbase)";
	m_szSQL			= "{call sqlbench (?)}";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+01;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_01::~CXact_OLTP_Write_01 (void)
{
}

BOOL CXact_OLTP_Write_01::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_01::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_01::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int ReturnCode;
	SQLINTEGER BindParamInd;
	unsigned long randbase;

	// initialize variables
	BindParamInd = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_QUERY_TIMEOUT, (PTR)1200, SQL_IS_INTEGER);
	CHECK_FOR_ERROR;

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbase, sizeof(randbase), &BindParamInd);
	CHECK_FOR_ERROR;
	
	// ==========
	
	// initialize variables (NOTE CHANGE HERE TO SMALL DATASET)
	randbase = (long) m_CRandom.GetRandom(2,190000);	// lowered from 1,000,000 to prevent referential integrity failures

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE;

	// update statistics
	m_nTotalRows = 0;
	m_nTotalBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Write_02

CXact_OLTP_Write_02::CXact_OLTP_Write_02 (void)
{
	m_szName		= "OLTP Write 02";
	m_szDescription = "oltp_write_02 (randbase)";
	m_szSQL			= "{call oltp_write_02 (?)}";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+02;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_02::~CXact_OLTP_Write_02 (void)
{
}

BOOL CXact_OLTP_Write_02::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_02::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_02::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int ReturnCode;
	SQLINTEGER BindParamInd;
	unsigned long randbase;

	// initialize variables
	BindParamInd = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_QUERY_TIMEOUT, (PTR)1200, SQL_IS_INTEGER);
	CHECK_FOR_ERROR;

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbase, sizeof(randbase), &BindParamInd);
	CHECK_FOR_ERROR;
	
	// ==========
	
	// initialize variables
	randbase = (long) m_CRandom.GetRandom(2,1000000);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE;

	// update statistics
	m_nTotalRows = 0;
	m_nTotalBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Write_03

CXact_OLTP_Write_03::CXact_OLTP_Write_03 (void)
{
	m_szName		= "OLTP Write 03";
	m_szDescription = "oltp_write_03 (randfivemill)";
	m_szSQL			= "{call oltp_write_03 (?)}";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+03;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_03::~CXact_OLTP_Write_03 (void)
{
}

BOOL CXact_OLTP_Write_03::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_03::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_03::Execute (void)
{
	
	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int ReturnCode;
	SQLINTEGER BindParamInd;
	unsigned long randfivemill;

	// initialize variables
	BindParamInd = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_QUERY_TIMEOUT, (PTR)1200, SQL_IS_INTEGER);
	CHECK_FOR_ERROR;

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randfivemill, sizeof(randfivemill), &BindParamInd);
	CHECK_FOR_ERROR;

	// ==========
	
	// initialize variables
	randfivemill = (long) m_CRandom.GetRandom(2,5000000);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE;

	// update statistics
	m_nTotalRows = 0;
	m_nTotalBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Write_04

CXact_OLTP_Write_04::CXact_OLTP_Write_04 (void)
{
	m_szName		= "OLTP Write 04";
	m_szDescription = "oltp_write_04 (randfourmill)";
	m_szSQL			= "{call oltp_write_04 (?)}";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+04;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_04::~CXact_OLTP_Write_04 (void)
{
}

BOOL CXact_OLTP_Write_04::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_04::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_04::Execute (void)
{
	
	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int ReturnCode;
	SQLINTEGER BindParamInd;
	unsigned long randfourmill;

	// initialize variables
	BindParamInd = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_QUERY_TIMEOUT, (PTR)1200, SQL_IS_INTEGER);
	CHECK_FOR_ERROR;

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randfourmill, sizeof(randfourmill), &BindParamInd);
	CHECK_FOR_ERROR;

	// ==========
	
	// initialize variables
	randfourmill = (long) m_CRandom.GetRandom(2,4000000);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE;

	// update statistics
	m_nTotalRows = 0;
	m_nTotalBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Write_05

CXact_OLTP_Write_05::CXact_OLTP_Write_05 (void)
{
	m_szName		= "OLTP Write 05";
	m_szDescription = "oltp_write_05 (randbase)";
	m_szSQL			= "{call oltp_write_05 (?)}";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+05;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_05::~CXact_OLTP_Write_05 (void)
{
}

BOOL CXact_OLTP_Write_05::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_05::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_05::Execute (void)
{
	
	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int ReturnCode;
	SQLINTEGER BindParamInd;
	unsigned long randbase;

	// initialize variables
	BindParamInd = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_QUERY_TIMEOUT, (PTR)1200, SQL_IS_INTEGER);
	CHECK_FOR_ERROR;

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbase, sizeof(randbase), &BindParamInd);
	CHECK_FOR_ERROR;

	// ==========
	
	// initialize variables
	randbase = (long) m_CRandom.GetRandom(2,1000000);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE;

	// update statistics
	m_nTotalRows = 0;
	m_nTotalBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}
